# -*- coding: cp1252 -*-


######################################################################
#
# Name:  Create Weekyl Stats
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This script creates a job that executes the python script RR\SDK\External\Python\exportLastDaysTables.py.
#   This  script parses all statistics files of RR and creates an Excel (.csv) table  in RR\_inHouse\
#   The re-execute setting is set to 24x7 hours, so you get a new stat file each week
#   Note: To get an export at a specific day/time, please use the "Wait for" setting in the rrSubmitter.
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os




scriptFile= rrGlobal.rrRootPath() + "SDK/External/Python/Stats_exportLastDaysTables.py"




#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Python"
renderApp.type="Execute"
renderApp.executeType=rrGlobal.executeJobType.once
renderApp.rendererName="Create RR Stats"



newJob=  rr.getNewJob()
newJob.overrideIcon=""
newJob.sceneName=scriptFile
newJob.renderApp=renderApp
newJob.companyProjectName="rrCommand"
newJob.imageFileName=rrGlobal.rrRootPath()+"inhouse/stats_.csv"
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.layer="Create RR Stats"
newJob.customSet_Str("Flags","7 \""+rrGlobal.rrRootPath()+"inhouse\"")
newJob.seqStart = 1
newJob.seqEnd = 1
newJob.seqStep = 1

rr.setSubmitterParameter("Re-ExecuteJobAfterHours=1~"+str(24*7))



rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list.  So I use 999 as index.
